// ZipDlg.cpp : implementation file
//

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include "stdafx.h"
#include "Addr.h"
#include "ZipDlg.h"
#include <atlbase.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CZipDlg dialog

CZipDlg::CZipDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CZipDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CZipDlg)
	m_Build_Number = _T("");
	m_Database_Date = _T("");
	m_Init_Err = _T("");
	m_State = _T("");
	m_ZipCode = _T("");
	m_City = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	zip = NULL;
	zipCreated = false;

	//Initialize the COM library
	CoInitialize(0);
}

CZipDlg::~CZipDlg()
{
	//Release the Address Object

	if (zip)
	{
		zip->Release();
		zip = NULL;
	}


	//Uninitializes the COM library
	CoUninitialize();
}
void CZipDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZipDlg)
	DDX_Control(pDX, IDC_OUTPUT, m_Output);
	DDX_Text(pDX, IDC_BUILD_NUMBER, m_Build_Number);
	DDX_Text(pDX, IDC_DB_DATE, m_Database_Date);
	DDX_Text(pDX, IDC_INIT_ERR, m_Init_Err);
	DDX_Text(pDX, IDC_STATE, m_State);
	DDX_Text(pDX, IDC_ZIP, m_ZipCode);
	DDX_Text(pDX, IDC_CITY, m_City);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CZipDlg, CDialog)
	//{{AFX_MSG_MAP(CZipDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_FIND_CITY, OnFindCity)
	ON_BN_CLICKED(IDC_FIND_ZIP, OnFindZip)
	ON_BN_CLICKED(IDC_FIND_ZIP_CITY, OnFindZipCity)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZipDlg message handlers

BOOL CZipDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	try
	{
		// New COM - AddressCoder Object - ZipCodeData interface
		zip = new IZipCodeDataPtr(__uuidof(ZipCodeData));


		zipCreated = true;
		initZip();

		//Update input data with default
		UpdateData();
		m_ZipCode="89101";
		m_State="NV";
		m_City="Las Vegas";
		UpdateData(false);

	}
	catch(const _com_error &e)
	{
		AfxMessageBox(e.ErrorMessage());
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CZipDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
//		CAboutDlg dlgAbout;
//		dlgAbout.DoModal();
		int x=0;
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CZipDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CZipDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CZipDlg::OnFindCity()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;
	CString cBuff, cCity, cState;

	UpdateData();

	_variant_t pCity((LPCTSTR)m_City);
	_variant_t pState((LPCTSTR)m_State);

	if (zip->FindCityInState(pCity, pState) == 0)
	{
		AfxMessageBox("Unable to locate City in State.");
		return;
	}
	else
	{
		retStr = (LPCOLESTR)zip->GetCity();
		cCity = retStr.Detach();

		retStr = (LPCOLESTR)zip->GetState();
		cState = retStr.Detach();

		cBuff = cCity + "    " + cState;

		m_Output.AddString((LPCTSTR)cBuff);

		while (zip->FindCityInStateNext() != 0)
		{
			retStr = (LPCOLESTR)zip->GetCity();
			cCity = retStr.Detach();

			retStr = (LPCOLESTR)zip->GetState();
			cState = retStr.Detach();

			cBuff = cCity + "    " + cState;
			m_Output.AddString((LPCTSTR)cBuff);
		}
	}

	UpdateData(FALSE);
}

void CZipDlg::OnFindZip()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;
	CString cZip, cCity, cState, cBuff, cTemp;


	UpdateData();

	_variant_t pZip((LPCTSTR)m_ZipCode);

	if (zip->FindZip(pZip, "0") == 0)
	{
		AfxMessageBox("Unable to ZIP Code.");

		return;
	}
	else
	{
		//retStr = (LPCOLESTR)zip->GetZip();
		//cZip = retStr.Detach();

		//retStr = (LPCOLESTR)zip->GetCity();
		//cCity = retStr.Detach();

		//retStr = (LPCOLESTR)zip->GetState();
		//cState = retStr.Detach();

		//cBuff = cZip + "    " + cCity + "    " + cState;
		cBuff.Empty();

		retStr = (LPCOLESTR)zip->Zip;
		cTemp=retStr.Detach();
		cBuff=" "+cTemp;
		retStr = (LPCOLESTR)zip->City;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->State;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->AreaCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Automation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CityAbbreviation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyFips;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyName;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->FacilityCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineIndicator;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Latitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Longitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Msa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Pmsa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->PreferredLastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZone;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZoneCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->ZipType;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		m_Output.AddString((LPCTSTR)cBuff);


		while (zip->FindZipNext() != 0)
		{
		cBuff.Empty();

		retStr = (LPCOLESTR)zip->Zip;
		cTemp=retStr.Detach();
		cBuff=" "+cTemp;
		retStr = (LPCOLESTR)zip->City;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->State;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->AreaCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Automation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CityAbbreviation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyFips;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyName;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->FacilityCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineIndicator;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Latitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Longitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Msa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Pmsa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->PreferredLastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZone;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZoneCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->ZipType;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		m_Output.AddString((LPCTSTR)cBuff);;
		}
	}

	UpdateData(FALSE);

}

void CZipDlg::OnFindZipCity()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;
	CString cBuff, cCity, cState, cZip,cTemp;

	UpdateData();

	//convert our input to a _variant_t
	_variant_t pCity((LPCTSTR)m_City);
	_variant_t pState((LPCTSTR)m_State);

	//This is our call to the FindZipInCity method
	if (zip->FindZipInCity(pCity, pState) == 0)
	{
		//Nothing found
		AfxMessageBox("Unable to locate City in State.");
		return;
	}
	else
	{
		//Let's retrieve our Properties
		//retStr = (LPCOLESTR)zip->GetCity();
		//cCity = retStr.Detach();

		//retStr = (LPCOLESTR)zip->GetState();
		//cState = retStr.Detach();

		//retStr = (LPCOLESTR)zip->GetZip();
		//cZip = retStr.Detach();

		//cBuff = cCity + "    " + cState  + "    " + cZip ;

		//m_Output.AddString((LPCTSTR)cBuff);
		cBuff.Empty();

		retStr = (LPCOLESTR)zip->Zip;
		cTemp=retStr.Detach();
		cBuff=" "+cTemp;
		retStr = (LPCOLESTR)zip->City;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->State;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->AreaCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Automation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CityAbbreviation;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyFips;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->CountyName;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->FacilityCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineIndicator;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->LastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Latitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Longitude;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Msa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->Pmsa;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->PreferredLastLineNumber;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZone;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->TimeZoneCode;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)zip->ZipType;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		m_Output.AddString((LPCTSTR)cBuff);
		//Let's see if we have any more
		while (zip->FindZipInCityNext() != 0)
		{
			cBuff.Empty();

			retStr = (LPCOLESTR)zip->Zip;
			cTemp=retStr.Detach();
			cBuff=" "+cTemp;
			retStr = (LPCOLESTR)zip->City;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->State;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->AreaCode;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->Automation;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->CityAbbreviation;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->CountyFips;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->CountyName;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->FacilityCode;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->LastLineIndicator;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->LastLineNumber;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->Latitude;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->Longitude;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->Msa;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->Pmsa;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->PreferredLastLineNumber;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->TimeZone;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->TimeZoneCode;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)zip->ZipType;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			m_Output.AddString((LPCTSTR)cBuff);
		}
	}

	UpdateData(FALSE);

}



void CZipDlg::OnCancel()
{
	CDialog::OnCancel();
}

bool CZipDlg::initZip()
{
	COleDateTime date;
	CComBSTR ccbString;

	zip->SetLicenseString(_bstr_t(dLICENSE));

	if ( zipCreated == false )
		return false;

	UpdateData();

	//Here is where we call the Initialize method
	//You must pass the paths to the mdaddr.dat, mdaddr.nat, & mdaddr.str files
	if (zip->Initialize(_bstr_t(dFILELOC),_bstr_t(dFILELOC),"") != 0)
	{
		// Error -- so let's find out what went wrong with a simple call to the
		// GetInitializeErrorString method
		ccbString = (LPCOLESTR)zip->GetInitializeErrorString();

		//Pass the Error string back from a BSTR to a CString
		m_Init_Err = ccbString.Detach();

		return false;
	}

	//the initialization was successful.

	// A call to the GetDatabaseDate method
	date = zip->GetDatabaseDate();

	//Just a little Date manipulation so we can view the Date
	m_Database_Date.Format("%d/%d/%d", date.GetMonth(), date.GetDay(), date.GetYear());

	// A simple call to the GetBuildNumber method
	ccbString = (LPCOLESTR)zip->GetBuildNumber();

	//BSTR to CString
	m_Build_Number = ccbString.Detach();

	//Just to show you the Error string returned from a successful Initialization
	ccbString = (LPCOLESTR)zip->GetInitializeErrorString();

	//BSTR to CString
	m_Init_Err = ccbString.Detach();

	zipInit = true;
	UpdateData(FALSE);

	return true;
}

void CZipDlg::OnClear()
{
	m_Output.ResetContent( );
	m_City.Empty();
	m_State.Empty();
	m_ZipCode.Empty();
	UpdateData(FALSE);

}


